<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Plakat Filmowy na Pełnym Ekranie</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: rgba(34, 34, 34, 0.5); /* Dostosuj wartość alfa (0.5 dla 50% przezroczystości) */
            backdrop-filter: blur(0px);
            background-repeat: no-repeat;
            background-size: cover;
            position: relative;
            overflow: hidden;
        }

        /* Dodaj właściwości przejścia dla animacji przesuwania */
        #poster-container {
            transition: transform 0.5s ease-in-out;
            position: relative;
        }

        #poster-container {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 100%;
            height: 100vh;
        }

        #poster {
            width: 100vw; /* Ustaw szerokość na 100% szerokości widoku */
            height: 100vh; /* Ustaw wysokość na 100% wysokości widoku */
            object-fit: fixed; /* Zachowaj proporcje i pokryj cały obszar */
        }

        #movie-info {
            position: absolute;
            bottom: 20px;
            left: 10px;
            color: white;
            font-size: 20px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            max-width: 80%;
            background-color: rgba(0, 0, 0, 0.7); /* Kolor tła z przezroczystością */
            padding: 20px;
            border-radius: 15px; /* Zaokrąglone narożniki */
        }
    </style>
</head>
<body>
    <div id="poster-container">
        <img id="poster" src="../logo/bg.php" alt="Plakat Filmowy">
        <div id="movie-info">
            <h2 id="movie-title"></h2>
            <p id="movie-release-date"></p>
            <p id="movie-overview"></p>
        </div>
    </div>
    <script async>
        const apiKey = '59b62063232f5adc864355aa4fa216f2'; // Zastąp 'YOUR_API_KEY' swoim rzeczywistym kluczem API
        let currentIndex = 0;
        let movieIds = [];

        async function fetchPopularMovies() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc`);
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error('Nie udało się pobrać popularnych filmów:', error);
            }
        }

        async function updateMovieInfo() {
            if (movieIds.length === 0) {
                console.error('Brak dostępnych identyfikatorów filmów.');
                return;
            }

            const movieId = movieIds[currentIndex];

            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=pl`);
                const data = await response.json();
                const posterContainer = document.getElementById('poster-container');
                const poster = document.getElementById('poster');
                const movieTitle = document.getElementById('movie-title');
                const movieReleaseDate = document.getElementById('movie-release-date');
                const movieOverview = document.getElementById('movie-overview');

                // Dodaj efekt wysuwania poprzez przesunięcie kontenera w lewo
                posterContainer.style.transform = 'translateX(-100%)';

                // Wstępnie załaduj następny obraz
                preloadNextImage(currentIndex);

                // Poczekaj na zakończenie animacji, a następnie zaktualizuj plakat i zresetuj pozycję
                setTimeout(() => {
                    poster.src = `https://image.tmdb.org/t/p/original${data.poster_path}`;
                    movieTitle.textContent = data.title;
                    movieReleaseDate.textContent = `Data premiery: ${data.release_date}`;
                    movieOverview.textContent = data.overview;
                    posterContainer.style.transform = 'translateX(0)';
                }, 500); // Dostosuj czas trwania, jeśli potrzeba

                currentIndex = (currentIndex + 1) % movieIds.length;
            } catch (error) {
                console.error('Nie udało się pobrać szczegółów filmu:', error);
            }
        }

        async function preloadNextImage(index) {
            const nextIndex = (index + 1) % movieIds.length;
            const nextMovieId = movieIds[nextIndex];

            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${nextMovieId}?api_key=${apiKey}&language=pl`);
                const data = await response.json();
                const nextImage = new Image();
                nextImage.src = `https://image.tmdb.org/t/p/original${data.poster_path}`;
            } catch (error) {
                console.error('Nie udało się wstępnie załadować następnego obrazu:', error);
            }
        }

        fetchPopularMovies().then(() => {
            preloadNextImage(currentIndex);
            setTimeout(updateMovieInfo, 2000);
            setInterval(updateMovieInfo, 9000);
        });
    </script>
</body>
</html>
